---
title: "Commandes Docker essentielles"
course: "docker"
slug: "4-commandes-docker-essentielles"
order: 4
createdAt: 2025-09-24
updatedAt: 2025-09-24
---

Voici les commandes de base que tout utilisateur Docker doit connaître. Elles permettent de créer, exécuter, gérer et inspecter des conteneurs et des images.

---

## Lancer un conteneur

```bash
docker run [options] image_name
```

**Exemple :**

```bash
docker run hello-world
```

**Options courantes :**

- `-d` : mode détaché (en arrière-plan)
- `-p 8080:80` : mappe le port 80 du conteneur au port 8080 de la machine hôte
- `--name mon_conteneur` : donne un nom au conteneur
- `-v ./mon_dossier:/app` : monte un volume (ex. dossier local vers le conteneur)
- `-it` : mode interactif avec terminal
- `--rm` : supprime automatiquement le conteneur à l'arrêt

**Exemple complet :**

```bash
docker run -d -p 8080:80 --name mon-serveur nginx
```

---

## Lister les conteneurs

```bash
docker ps          # Conteneurs en cours d'exécution
docker ps -a       # Tous les conteneurs (même arrêtés)
```

**Options utiles :**

- `-q` : affiche seulement les IDs
- `--filter` : filtre par critères (ex. `--filter "status=exited"`)

---

## Arrêter et supprimer un conteneur

```bash
docker stop nom_ou_id
docker rm nom_ou_id
```

**Raccourci pour forcer l'arrêt et supprimer :**

```bash
docker rm -f nom_ou_id
```

> [!warning] Important
> Un conteneur arrêté reste sur ta machine tant qu'il n'est pas supprimé.

---

## Construire une image à partir d'un Dockerfile

```bash
docker build -t mon_image .
```

**Options :**

- `-t mon_image` : nomme l'image
- `.` : indique le chemin où se trouve le Dockerfile
- `--no-cache` : force la reconstruction sans utiliser le cache

---

## Lister les images disponibles localement

```bash
docker images
```

**Informations affichées :**

- Repository (nom de l'image)
- Tag (version)
- Image ID
- Taille

---

## Supprimer une image

```bash
docker rmi nom_image
```

> [!info] Prérequis
> Tous les conteneurs basés sur cette image doivent être supprimés au préalable.

---

## Exécuter une commande dans un conteneur

```bash
docker exec -it nom_ou_id bash
```

**Options importantes :**

- `-i` : mode interactif (garde STDIN ouvert)
- `-t` : alloue un pseudo-TTY (terminal)
- `bash` ou `sh` : lance un shell dans le conteneur

**Exemples :**

```bash
docker exec -it mon_conteneur ls /app
docker exec -it mon_conteneur python manage.py migrate
```

---

## Voir les logs d'un conteneur

```bash
docker logs nom_ou_id
```

**Options utiles :**

- `-f` : suit les logs en temps réel (comme `tail -f`)
- `--tail 100` : affiche les 100 dernières lignes
- `--since 2h` : logs des 2 dernières heures

**Exemple :**

```bash
docker logs -f --tail 50 mon-serveur
```

---

## Inspecter un conteneur ou une image

```bash
docker inspect nom_ou_id
```

Cette commande retourne des informations détaillées au format JSON (configuration, réseaux, volumes, etc.).

---

## Copier des fichiers

**Du conteneur vers l'hôte :**

```bash
docker cp conteneur:/chemin/fichier ./fichier_local
```

**De l'hôte vers le conteneur :**

```bash
docker cp ./fichier_local conteneur:/chemin/fichier
```

---

## Gestion des volumes

```bash
docker volume create mon_volume      # Créer un volume
docker volume ls                     # Lister les volumes
docker volume inspect mon_volume     # Inspecter un volume
docker volume rm mon_volume          # Supprimer un volume
```

---

## Nettoyage du système

### Nettoyage complet (attention !)

```bash
docker system prune
```

Cette commande supprime :

- Tous les conteneurs arrêtés
- Tous les réseaux non utilisés
- Toutes les images sans tag
- Tout le cache de build

### Nettoyage avec volumes

```bash
docker system prune -a --volumes
```

> [!warning] Attention
> Ces commandes peuvent supprimer des ressources que vous vouliez conserver. Utilisez avec prudence !

### Nettoyages spécifiques

```bash
docker container prune    # Supprimer les conteneurs arrêtés
docker image prune        # Supprimer les images non utilisées
docker volume prune       # Supprimer les volumes non utilisés
docker network prune      # Supprimer les réseaux non utilisés
```

---

## Afficher des statistiques

```bash
docker stats                    # Statistiques de tous les conteneurs
docker stats nom_conteneur      # Statistiques d'un conteneur spécifique
```

Affiche en temps réel : CPU, mémoire, réseau, I/O disque.

---

## Résumé des commandes essentielles

|Commande|Description|
|---|---|
|`docker run`|Lance un nouveau conteneur|
|`docker ps`|Liste les conteneurs|
|`docker stop/start`|Arrête/démarre un conteneur|
|`docker rm`|Supprime un conteneur|
|`docker build`|Construit une image|
|`docker images`|Liste les images|
|`docker rmi`|Supprime une image|
|`docker exec`|Exécute une commande dans un conteneur|
|`docker logs`|Affiche les logs|
|`docker system prune`|Nettoie le système|

---

## Liens vers la partie suivante

- [[5. Créer sa première image avec un Dockerfile]]

---

## Tags

#docker #commandes #cli #gestion-conteneurs #docker-run #docker-exec #docker-logs